<?
/*
Plugin Name: Delete Matching Comments
Description: Marks unapproved comments as spam that contain words/phrases specified in the settings of this plugin.
Version: 1.2
Author: Tom Adam Shani
Author URI: http://laggingtom.com
License: GPL2

  	Copyright 2013 Tom Adam Shani (email : tom@laggingtom.com)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License, version 2, as 
    published by the Free Software Foundation.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

// Setup functions - called at the bottom of the script
function dmc_init(){
	// Add to Settings menu
	add_action( 'admin_menu', 'dmc_menu' );
	add_action( 'admin_enqueue_scripts', 'dmc_getJS' );
	add_action( 'admin_head', 'dmc_getJS' );
	$plugin = plugin_basename(__FILE__); 
	add_filter("plugin_action_links_$plugin", 'dmc_settings_link' );
}

function dmc_getJs($hook){
	if( 'settings_page_delete-matching-comments' != $hook )
        return;
	wp_deregister_script('jquery');
	wp_register_script('jquery', 'http://ajax.googleapis.com/ajax/libs/jquery/1.10.1/jquery.min.js', false, '1.10.1');
	wp_register_script('dmc-js', plugins_url('/dmc.js', __FILE__), false, '1.0');
	wp_enqueue_script('jquery');
	wp_enqueue_script('dmc-js');
}

// Setup the option page under Settings
function dmc_menu() {
	add_options_page('Matching Comments Options', 'Delete Matching Comments', 'manage_options', 'delete-matching-comments', 'dmc_options' );
}

// Setup options page
function dmc_options() {
	if ( !current_user_can( 'manage_options' ) )  {
		wp_die( __( 'You do not have sufficient permissions to access this page.' ) );
	}
	$dmc = new dmcClass();
	echo $dmc->getStyles();
	$pluginUrl = plugins_url(false, __FILE__);
	?>
	<div class="wrap">
		<h1>Delete Matching Comments</h1>
		<h2>Settings</h2>
		<p class="return-message"></p>
		<p>Enter as many keywords as you like, separated by a comma. Not case-sensitive.<br/><strong>Ex:</strong> some,words,i don't,like</p>
		<p>If you made changes to the word list, click "Update Word List" first.<br/>Click "Removed Matched Comments" to remove comments with the matched word/phrase in their content.</p>
		<? $dmc->echoList(); ?><br/>
		<small>You must have at least 1 word in this list.</small>
		<p>
			<a href="javascript:dmcUpdateKeywords('<? echo $pluginUrl ?>');">Update Word List</a> | 
			<a href="javascript:dmcRemoveMatchedComments('<? echo $pluginUrl ?>')">Remove Matched Comments</a>
		</p>
	</div>
	<?
}

class dmcClass {
	protected $wordlist = '';
	protected $dmc_echo = '';
	
	public function __construct(){
		if (!get_option('dmc_wordlist'))
			add_option('dmc_wordlist','{"0":"test value"}');
		
		$this->wordlist = get_option('dmc_wordlist');
		$this->parseListForOutput();
	}
	
	private function parseListForOutput(){
		if ($this->wordlist){
			$words = json_decode($this->wordlist,true);
			if (!$words) $this->dmc_error(2); else {
				$this->dmc_echo = '<textarea rows="10" cols="75" id="dmc-wordlist">';
				foreach($words as $w){
					$this->dmc_echo .= $w.',';
				}
				$this->dmc_echo = substr($this->dmc_echo, 0, strlen($this->dmc_echo)-1);
				$this->dmc_echo .= '</textarea>';
			}
		} else $this->dmc_error(0);
	}
	
	public function echoList(){
		if ($this->dmc_echo) 
			echo $this->dmc_echo;
		else dmc_error(1);
	}
	
	public function getStyles(){
		?>
		<style>
		.return-message{
			background: #800;
			display: none;
			padding:10px 15px;
			position:relative;
			-webkit-border-radius: 5px;
			border-radius: 5px;
		}
		.return-message > span{
			color: white;
			font-weight: bold;
			letter-spacing: 0.13em;
			
		}
		.return-message > span a{
			color: #eee;
			font-size: 1.5em;
			padding:5px;
			position:absolute;
			top: 5px;
			right: 10px;
			text-decoration:none;
		}
		.return-message > span a:hover{
			color: #ccc;	
		}
		</style>
		<?
	}
	
	// Prints errors
	private function dmc_error($error_num){
		switch($error_num){
			case 0:
				$error_string = "Couldn't find 'dmc_wordlist' in options database.";
				break;
			case 1:
				$error_string = "Couldn't read dmc_echo.";
				break;
			case 2:
				$error_string = "json_decode failed.";
				break;
			default:
				$error_string = 'Something went wrong.';
				break;
		}
		echo "<strong>Error:</strong> ".$error_string;
	} 
}

// Add settings link on plugin page
function dmc_settings_link($links) { 
  $settings_link = '<a href="options-general.php?page=delete-matching-comments.php">Settings</a>'; 
  array_unshift($links, $settings_link); 
  return $links; 
}


dmc_init();

?>