<?

include('mysql.class.php');

$dbuser = 'root';		// Set the username for the query
$dbpass = 'root';		// Set the password
$dbhost = 'localhost';	// Set the hostname
$dbname = 'berk';		// Set the database name containing the berklee tables

$mydb = new MySQL($dbname, $dbuser, $dbpass);


if ($_POST['query'] == 'user')
	echo berk_format(berk_getUserTable($mydb));
else if ($_POST['query'] == 'node')
	echo berk_format(berk_getNodesTable($mydb));
else if ($_POST['query'] == 'compare'){
	if ($_POST['corrections'] == 0)
		berk_startQuery($mydb, false, false);
    else berk_startQuery($mydb, true, false);
}
else if ($_POST['query'] == 'list-mods')
	berk_startQuery($mydb, true, true);
else if ($_POST['query'] == 'write-query')
	berk_getQuery($mydb);
else echo 'bad query to berklee_users_update';

function berk_startQuery($mydb, $corrections, $listMods){
	$merged = berk_mergeArrays($mydb, $corrections, $listMods);
	if (is_array($merged)){
		$return = '
		<p>Number of matched queries 
		- Total: '.$merged['number-success']['total'].'
		- Valid: '.$merged['number-success']['valid'].' 
		- Invalid: '.$merged['number-success']['invalid'].'</p>
		<table>
			<thead>
				<th>nodes-nid</th>
				<th>nodes-name</th>
				<th>user-name</th>
				<th>user-uid</th>
				<th>nodes-uid</th>
				<th>matched by</th>
				<th>extra matches?</th>
			</thead>';
		foreach ($merged['data'] as $row){
			if ($row['numMatches'] < 2) $row['numMatches'] = '';
			else $row['numMatches'] = $row['numMatches'].' matches this row';
			$return .= '<tr class="notes node-'.$row['n_nid'].'">';
				$return .= '<td><a name="'.$row['n_nid'].'">'.$row['n_nid'].'</a></td>';
				$return .= '<td>'.$row['n_name'].'</td>';
				$return .= '<td>'.$row['u_name'].'</td>';
				$return .= '<td>'.$row['u_uid'].'</td>';
				$return .= '<td>'.$row['n_uid'].'</td>';
				$return .= '<td>'.$row['matchedBy'].'</td>';
				$return .= '<td class="num-matches">'.$row['numMatches'].'</td>';
			$return .= '</tr>';
		}
		$return .= '</table>';
	} else $return = 'error';
	echo $return;
}

function berk_getQuery($mydb, $corrections = 1, $listMods = 1){
	$merged = berk_mergeArrays($mydb, $corrections, $listMods);
	$return = null;
	$case = null;
	$wherein = null;
	if (is_array($merged)){
		$first = true;
		foreach($merged['data'] as $row){
			$case .= 'WHEN '.$row['n_nid'].' THEN '.$row['u_uid'].'<br/> ';
			if ($first) $first = false;
				else $wherein .= ", ";
			$wherein .= $row['n_nid'];
		}
		$return .= 'UPDATE node SET uid = CASE nid <br/>'.$case;
		$return .= 'ELSE uid END WHERE nid IN ';
		$return .= '('.$wherein.')';
	}
	echo $return;
}

function berk_mergeArrays($mydb, $corrections, $listMods){
	$numMatches = array('total' => 0, 'valid' => 0, 'invalid' => 0);

	$rows = array();

	$users = berk_getUserTable($mydb);
	$nodes = berk_getNodesTable($mydb);
	foreach ($nodes as $n){
		$row = null;
		$row['n_nid'] = $n['nid'];
		$row['n_name'] = $n['full_name'];
		$row['n_uid'] = $n['uid'];
		$row['n_first'] = $n['title'];
		$row['n_last'] = $n['last_name'];
		$row['n_sub'] = $n['sub'];
 		$row['u_uid'] = '';
		$row['u_name'] = '';
		$row['matchedBy'] = '';
		$row['numMatches'] = 0;

		foreach ($users as $u){
			$rep = array(' ', ',', '.', ' Jr.');
			$uname = str_replace($rep, '', trim($u['full_name']));
				$ufirstname = substr($uname, 0, strpos($uname, ' '));
			$nname = str_replace($rep, '', trim($n['full_name']));
			if (
					
					( strcasecmp($nname, $uname) == 0 ) || 
					( strncasecmp($nname, $uname, 11) == 0 ) || //compares first 11 characters
					( strncasecmp(strrev($nname), strrev($uname), 12) == 0 ) || // compares last 11 characters
					( strcasecmp($u['sub'], $row['n_sub']) == 0)

				){
				$row['numMatches']++;
				if ($row['numMatches'] == 1) {
					$numMatches['valid']++;
				} else {
					$numMatches['invalid']++;
				}

				if (strcasecmp($nname, $uname) == 0) $row['matchedBy'] = 'full name';
					else if (strncasecmp($nname, $uname, 11) == 0) $row['matchedBy'] = 'first 11 chars';
					else if (strncasecmp(strrev($nname), strrev($uname), 12) == 0) $row['matchedBy'] = 'last 11 chars';
					else if (strcasecmp($u['sub'], $row['n_sub']) == 0) $row['matchedBy'] = 'substr';

				$row['u_name'] = $u['full_name'];
				$row['u_uid'] = $u['uid']; 

				if ($corrections) {
					if ($row['n_nid'] == 1049315) {
						$row['u_uid'] = 174718;
						$row['u_name'] = "Jeffrey Williams";
						$row['matchedBy'] = 'exception';
					} 

					if ($row['n_nid'] == 1049539) {
						$row['u_uid'] = 174397;
						$row['u_name'] = "Doug Johnson";
						$row['matchedBy'] = 'exception';
					} 

					if ($row['n_nid'] == 1048890) {
						$row['u_uid'] = 174678;
						$row['u_name'] = "Ben Thomas";
						$row['matchedBy'] = 'exception';
					} 

					if ($row['n_nid'] == 1048901) {
						$row['u_uid'] = 174624;
						$row['u_name'] = "Maggie Scott";
						$row['matchedBy'] = 'exception';
					} 

					if ($row['n_nid'] == 1049256) {
						$row['u_uid'] = 174719;
						$row['u_name'] = "Michael M. Williams";
						$row['matchedBy'] = 'exception';
					} 
					
					if ($row['n_nid'] == 1049581) {
						$row['u_uid'] = 0;
						$row['u_name'] = "Steve Bailey";
						$row['matchedBy'] = 'exception';
					} 

					
				}
				
					

				$numMatches['total']++;
			} 
		}
		if ( ( $row['u_uid'] == '' && $listMods ) ){
				// don't print it
		} else array_push($rows, $row);
		
	}
	$return = array('number-success' => $numMatches, 'data' => $rows);
	return $return;
}

// Calls, formats and stores the user table into an array
function berk_getUserTable($mydb){
	$users = null;
	$userQuery = $mydb->ExecuteSQL("SELECT uid, data, name FROM `users`");
	foreach ($userQuery as $u){
		$pos = strpos($u['data'], 'OU=Faculty');
		if ($pos !== false){
			$name = substr($u['data'], strpos($u['data'], 'CN=')); // erase everything before CN=
			$name = substr($name, 3, strpos($name, ',')-3); // erase extra trailing characters
			$users[$u['uid']] = array('uid'=>$u['uid'], 'full_name' => $name, 'sub' => $u['name']);
		}
	}
	//$users = uasort($users, 'cmp');
	uasort($users, 'nodecmp');
	return $users;
}

function berk_getNodesTable($mydb){
	$nodes = null;
	$query = $mydb->ExecuteSQL("SELECT 
		node.nid, 
		node.uid, 
		node.title, 
		field_data_field_last_name.field_last_name_value, 
		REPLACE(
		 REPLACE(
		  REPLACE(
		   REPLACE(
		    REPLACE(
				LCASE(CONCAT(SUBSTR(TRIM(node.title), 1, 1), TRIM(field_data_field_last_name.field_last_name_value))),
			',', ''),
		   '.', ''),
		  ' ', ''), 
		 '-', ''),
		\"'\", '')
		AS sub
	FROM `node`
	INNER JOIN `field_data_field_last_name`
		ON node.nid=field_data_field_last_name.entity_id
	ORDER BY field_data_field_last_name.field_last_name_value");

	foreach($query as $node){
		$nodes[$node['nid']] = array(
				'nid' => $node['nid'],
				'uid' => $node['uid'],
				'full_name' => $node['title'].' '.$node['field_last_name_value'],
				'last_name' => $node['field_last_name_value'],
				'title' => $node['title'],
				'sub' => $node['sub']
			);
	}
	uasort($nodes, 'nodecmp');
	return $nodes;
}

function berk_format($data){
	$return = null;
	foreach ($data as $k => $v){
		$return .= $k.": ";
		if (is_array($v)) $return.= $v['full_name'];
			else $return.= $v;
		$return .= "<br/>";
	}

	return $return;
}

function nodecmp($a, $b){return strcmp($a["full_name"], $b["full_name"]);} // for sorting the arrays alphabetically
function usercmp($a, $b){return strcmp($a, $b);}
?>